/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.structure;

import java.io.DataInputStream;
import java.util.zip.GZIPInputStream;
import mod.lucky.Lucky;
import mod.lucky.drop.DropSingle;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.structure.BlockPlacer;
import mod.lucky.structure.Structure;
import mod.lucky.structure.StructureUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.fixes.ItemIntIDToString;
import net.minecraft.util.datafix.fixes.ItemStackDataFlattening;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class LegacySchematicStructure
extends Structure {
    private BlockState[][][] blocks;
    private int[][][] blockData;
    private CompoundNBT[] entities;
    private CompoundNBT[] tileEntities;

    @Override
    public void process(DropProcessData processData) {
        DropSingle drop = processData.getDropSingle();
        Vec3d harvestPos = drop.getVecPos();
        int rotation = drop.getPropertyInt("rotation");
        BlockPlacer blockPlacer = new BlockPlacer(processData.getRawWorld());
        for (int y = 0; y < this.size.func_177956_o(); ++y) {
            for (int z = 0; z < this.size.func_177952_p(); ++z) {
                for (int x = 0; x < this.size.func_177958_n(); ++x) {
                    BlockState blockStateInit = this.blocks[y][z][x];
                    BlockPos blockPos = new BlockPos(x, y, z);
                    BlockState blockState = StructureUtils.applyBlockMode(this.blockMode, blockStateInit);
                    if (blockState == null) continue;
                    StructureUtils.setBlock(blockPlacer, blockState, blockPos, this.centerPos, harvestPos, rotation);
                    if (this.blockMode == Structure.BlockMode.AIR || !drop.hasProperty("tileEntity")) continue;
                    StructureUtils.setTileEntity((IWorld)processData.getWorld(), drop.getPropertyNBT("tileEntity"), blockPos, this.centerPos, harvestPos, rotation);
                }
            }
        }
        for (CompoundNBT entityNbt : this.entities) {
            StructureUtils.setEntity(processData.getWorld(), EntityType.func_220335_a((CompoundNBT)entityNbt, (World)processData.getWorld(), e -> e), this.centerPos, harvestPos, rotation);
        }
        if (this.blockUpdate) {
            blockPlacer.update();
        }
        this.processOverlay(processData);
    }

    @Override
    public void readFromFile() {
        CompoundNBT nbt = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new GZIPInputStream(this.openFileStream()));
            nbt = CompressedStreamTools.func_74794_a((DataInputStream)dataInputStream);
            dataInputStream.close();
        }
        catch (Exception e) {
            Lucky.error(e, "Error loading legacy schematic structure '" + this.id + "'");
            e.printStackTrace();
        }
        this.size = new BlockPos((int)nbt.func_74765_d("Width"), (int)nbt.func_74765_d("Height"), (int)nbt.func_74765_d("Length"));
        this.blocks = new BlockState[this.size.func_177956_o()][this.size.func_177952_p()][this.size.func_177958_n()];
        byte[] blockIdsByte = nbt.func_74770_j("Blocks");
        byte[] blockDataByte = nbt.func_74770_j("Data");
        int x = 1;
        int y = 1;
        int z = 1;
        for (int i = 0; i < blockIdsByte.length; ++i) {
            short blockId = (short)(blockIdsByte[i] & 0xFF);
            byte blockData = blockDataByte[i];
            String legacyName = ItemIntIDToString.func_199173_a((int)blockId);
            String name = ItemStackDataFlattening.func_199175_a((String)legacyName, (int)blockData);
            if (legacyName.equals("minecraft:air") && blockId > 0) {
                name = "minecraft:stone";
            }
            if (name == null) {
                name = legacyName;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
            this.blocks[y - 1][z - 1][x - 1] = block.func_176223_P();
            if (++x > this.size.func_177958_n()) {
                x = 1;
                ++z;
            }
            if (z <= this.size.func_177952_p()) continue;
            z = 1;
            ++y;
        }
        ListNBT entityList = nbt.func_150295_c("Entities", 10);
        this.entities = new CompoundNBT[entityList.size()];
        for (int i = 0; i < entityList.size(); ++i) {
            this.entities[i] = entityList.func_150305_b(i);
        }
        ListNBT tileEntityList = nbt.func_150295_c("TileEntities", 10);
        this.tileEntities = new CompoundNBT[tileEntityList.size()];
        for (int i = 0; i < tileEntityList.size(); ++i) {
            this.tileEntities[i] = tileEntityList.func_150305_b(i);
        }
        this.initCenterPos();
    }
}

