/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.entity;

import javax.annotation.Nullable;
import mod.lucky.Lucky;
import mod.lucky.drop.DropFull;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import mod.lucky.init.SetupCommon;
import mod.lucky.util.ObfHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityLuckyProjectile
extends ArrowEntity {
    private static final DataParameter<ItemStack> ITEM_STACK = EntityDataManager.func_187226_a(EntityLuckyProjectile.class, (IDataSerializer)DataSerializers.field_187196_f);
    private ItemEntity entityItem;
    private boolean hasTrail = false;
    private float trailFrequency = 1.0f;
    private boolean hasImpact = false;
    private DropProcessor dropProcessorTrail;
    private DropProcessor dropProcessorImpact;

    public EntityLuckyProjectile(EntityType<? extends EntityLuckyProjectile> entityType, World world) {
        super(entityType, world);
    }

    public EntityLuckyProjectile(World world) {
        this(SetupCommon.ENTITY_LUCKY_PROJECTILE, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ITEM_STACK, (Object)ItemStack.field_190927_a);
        this.dropProcessorTrail = new DropProcessor();
        this.dropProcessorImpact = new DropProcessor();
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM_STACK);
    }

    private void setItemStack(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM_STACK, (Object)stack);
    }

    private void luckyTick() {
        Vec3d pos = this.func_174791_d();
        try {
            if (this.entityItem == null && this.func_130014_f_().field_72995_K) {
                this.entityItem = new ItemEntity(this.func_130014_f_(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (ItemStack)this.field_70180_af.func_187225_a(ITEM_STACK));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.entityItem != null) {
            this.entityItem.func_70071_h_();
        }
        if (!this.func_130014_f_().field_72995_K && this.hasTrail && this.field_70173_aa >= 2) {
            try {
                if ((double)this.trailFrequency < 1.0 && this.trailFrequency > 0.0f) {
                    int amount = (int)(1.0 / (double)this.trailFrequency);
                    for (int i = 0; i < amount; ++i) {
                        Vec3d entityMotion = this.func_213322_ci();
                        this.dropProcessorTrail.processRandomDrop(new DropProcessData((IWorld)this.func_130014_f_(), this.func_212360_k(), new Vec3d(pos.field_72450_a + entityMotion.field_72450_a * (double)i / (double)amount, pos.field_72448_b + entityMotion.field_72448_b * (double)i / (double)amount, pos.field_72449_c + entityMotion.field_72449_c * (double)i / (double)amount)), 0, false);
                    }
                } else if ((this.field_70173_aa - 2) % (int)this.trailFrequency == 0) {
                    this.dropProcessorTrail.processRandomDrop(new DropProcessData((IWorld)this.func_130014_f_(), this.func_212360_k(), this.func_174791_d()), 0, false);
                }
            }
            catch (Exception e) {
                Lucky.error(e, DropProcessor.errorMessage());
            }
        }
    }

    private void luckyHit(@Nullable Entity hitEntity) {
        try {
            if (this.hasImpact) {
                DropProcessData dropData = new DropProcessData((IWorld)this.func_130014_f_(), this.func_212360_k(), hitEntity != null ? hitEntity.func_174791_d() : this.func_174791_d());
                if (hitEntity != null) {
                    dropData.setHitEntity(hitEntity);
                }
                this.dropProcessorImpact.processRandomDrop(dropData, 0);
            }
        }
        catch (Exception e) {
            Lucky.error(e, DropProcessor.errorMessage());
        }
        this.func_70106_y();
    }

    public void func_70071_h_() {
        try {
            super.func_70071_h_();
            this.luckyTick();
        }
        catch (Exception e) {
            Lucky.error(e, "Error in lucky projectile tick");
        }
    }

    protected void func_184549_a(RayTraceResult rayTrace) {
        super.func_184549_a(rayTrace);
        if (rayTrace.func_216346_c() != RayTraceResult.Type.MISS) {
            if (!this.field_70170_p.field_72995_K) {
                Entity hitEntity = rayTrace.func_216346_c() == RayTraceResult.Type.ENTITY ? ((EntityRayTraceResult)rayTrace).func_216348_a() : null;
                this.luckyHit(hitEntity);
            }
            this.func_70106_y();
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.entityItem != null) {
            tag.func_218657_a("item", (INBT)this.entityItem.func_92059_d().func_77955_b(new CompoundNBT()));
        }
        if (this.hasTrail) {
            CompoundNBT trailTag = new CompoundNBT();
            trailTag.func_74776_a("frequency", this.trailFrequency);
            ListNBT drops = new ListNBT();
            for (int i = 0; i < this.dropProcessorTrail.getDrops().size(); ++i) {
                String dropString = this.dropProcessorTrail.getDrops().get(i).toString();
                drops.add((Object)ObfHelper.createStringNBT(dropString));
            }
            trailTag.func_218657_a("drops", (INBT)drops);
            tag.func_218657_a("trail", (INBT)trailTag);
        }
        if (this.hasImpact) {
            ListNBT drops = new ListNBT();
            for (int i = 0; i < this.dropProcessorImpact.getDrops().size(); ++i) {
                String dropString = this.dropProcessorImpact.getDrops().get(i).toString();
                drops.add((Object)ObfHelper.createStringNBT(dropString));
            }
            tag.func_218657_a("impact", (INBT)drops);
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        ItemStack stack = null;
        stack = tag.func_74764_b("item") ? ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("item")) : new ItemStack((IItemProvider)Items.field_151055_y);
        stack.func_190920_e(1);
        Vec3d pos = this.func_174791_d();
        this.entityItem = new ItemEntity(this.func_130014_f_(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack);
        this.func_184212_Q().func_187227_b(ITEM_STACK, (Object)stack);
        if (tag.func_74764_b("trail")) {
            CompoundNBT trailTag = tag.func_74775_l("trail");
            if (trailTag.func_74764_b("frequency")) {
                this.trailFrequency = trailTag.func_74760_g("frequency");
            }
            if (trailTag.func_74764_b("drops")) {
                ListNBT drops = trailTag.func_150295_c("drops", (int)ObfHelper.createStringNBT("").func_74732_a());
                for (int i = 0; i < drops.size(); ++i) {
                    DropFull drop = new DropFull();
                    drop.readFromString(drops.func_150307_f(i));
                    this.dropProcessorTrail.registerDrop(drop);
                }
            }
            this.hasTrail = true;
        }
        if (tag.func_74764_b("impact")) {
            ListNBT drops = tag.func_150295_c("impact", (int)ObfHelper.createStringNBT("").func_74732_a());
            for (int i = 0; i < drops.size(); ++i) {
                DropFull drop = new DropFull();
                drop.readFromString(drops.func_150307_f(i));
                this.dropProcessorImpact.registerDrop(drop);
            }
            this.hasImpact = true;
        }
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public ItemEntity getItemEntity() {
        return this.entityItem;
    }
}

