/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.tileentity.KitchenDrawerTileEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class KitchenDrawerBlock
extends FurnitureHorizontalBlock
implements ISidedInventoryProvider {
    public static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");
    public final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public KitchenDrawerBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DIRECTION, (Comparable)Direction.NORTH));
    }

    private VoxelShape getShape(BlockState state) {
        return this.SHAPES.computeIfAbsent(state, state1 -> {
            VoxelShape TOP = Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            VoxelShape[] DEFAULT_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)15.0), Direction.SOUTH));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(TOP);
            shapes.add(DEFAULT_BASE[((Direction)state.func_177229_b((IProperty)DIRECTION)).func_176736_b()]);
            return VoxelShapeHelper.combineAll(shapes);
        });
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getShape(state);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{OPEN});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (((Direction)state.func_177229_b((IProperty)DIRECTION)).func_176734_d() == result.func_216354_b()) {
            TileEntity tileEntity;
            if (!world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof KitchenDrawerTileEntity) {
                playerEntity.func_213829_a((INamedContainerProvider)tileEntity);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof KitchenDrawerTileEntity) {
            ((KitchenDrawerTileEntity)tileEntity).onScheduledTick();
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new KitchenDrawerTileEntity();
    }

    public ISidedInventory func_219966_a(BlockState state, IWorld world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ISidedInventory) {
            return (ISidedInventory)tileEntity;
        }
        return null;
    }
}

