/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class KitchenCounterBlock
extends FurnitureHorizontalBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.func_177709_a((String)"type", Type.class);
    public final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public KitchenCounterBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(TYPE, (Comparable)((Object)Type.DEFAULT))).func_206870_a((IProperty)DIRECTION, (Comparable)Direction.NORTH));
    }

    private VoxelShape getShape(BlockState state) {
        return this.SHAPES.computeIfAbsent(state, state1 -> {
            VoxelShape TOP = Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            VoxelShape[] DEFAULT_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)15.0), Direction.SOUTH));
            VoxelShape[] LEFT_INVERTED_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)15.0), Direction.SOUTH));
            VoxelShape[] RIGHT_INVERTED_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)13.0, (double)15.0), Direction.SOUTH));
            VoxelShape[] LEFT_CORNER_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)13.0, (double)16.0), Direction.SOUTH));
            VoxelShape[] RIGHT_CORNER_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)13.0, (double)16.0), Direction.SOUTH));
            Type type = (Type)((Object)((Object)state1.func_177229_b(TYPE)));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(TOP);
            switch (type) {
                case DEFAULT: {
                    shapes.add(DEFAULT_BASE[((Direction)state.func_177229_b((IProperty)DIRECTION)).func_176736_b()]);
                    break;
                }
                case LEFT_CORNER: {
                    shapes.add(DEFAULT_BASE[((Direction)state.func_177229_b((IProperty)DIRECTION)).func_176736_b()]);
                    shapes.add(LEFT_CORNER_BASE[((Direction)state.func_177229_b((IProperty)DIRECTION)).func_176736_b()]);
                    break;
                }
                case RIGHT_CORNER: {
                    shapes.add(DEFAULT_BASE[((Direction)state.func_177229_b((IProperty)DIRECTION)).func_176736_b()]);
                    shapes.add(RIGHT_CORNER_BASE[((Direction)state.func_177229_b((IProperty)DIRECTION)).func_176736_b()]);
                    break;
                }
                case LEFT_CORNER_INVERTED: {
                    shapes.add(LEFT_INVERTED_BASE[((Direction)state.func_177229_b((IProperty)DIRECTION)).func_176736_b()]);
                    break;
                }
                case RIGHT_CORNER_INVERTED: {
                    shapes.add(RIGHT_INVERTED_BASE[((Direction)state.func_177229_b((IProperty)DIRECTION)).func_176736_b()]);
                }
            }
            return VoxelShapeHelper.combineAll(shapes);
        });
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getShape(state);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getKitchenCounterState(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos newPos) {
        return this.getKitchenCounterState(state, world, pos);
    }

    private BlockState getKitchenCounterState(BlockState state, IWorld world, BlockPos pos) {
        BlockState backState;
        Direction direction = (Direction)state.func_177229_b((IProperty)DIRECTION);
        BlockState frontState = world.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (frontState.func_177230_c() instanceof KitchenCounterBlock) {
            if (frontState.func_177229_b((IProperty)DIRECTION) == direction.func_176746_e()) {
                return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.RIGHT_CORNER));
            }
            if (frontState.func_177229_b((IProperty)DIRECTION) == direction.func_176735_f()) {
                return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.LEFT_CORNER));
            }
        }
        if ((backState = world.func_180495_p(pos.func_177972_a(direction))).func_177230_c() instanceof KitchenCounterBlock) {
            BlockState rightState;
            BlockState leftState;
            if (!(backState.func_177229_b((IProperty)DIRECTION) != direction.func_176746_e() || (leftState = world.func_180495_p(pos.func_177972_a(direction.func_176735_f()))).func_177230_c() instanceof KitchenCounterBlock && leftState.func_177229_b((IProperty)DIRECTION) != direction.func_176734_d())) {
                return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.LEFT_CORNER_INVERTED));
            }
            if (!(backState.func_177229_b((IProperty)DIRECTION) != direction.func_176735_f() || (rightState = world.func_180495_p(pos.func_177972_a(direction.func_176746_e()))).func_177230_c() instanceof KitchenCounterBlock && rightState.func_177229_b((IProperty)DIRECTION) != direction.func_176734_d())) {
                return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.RIGHT_CORNER_INVERTED));
            }
        }
        return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)Type.DEFAULT));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{TYPE});
    }

    public static enum Type implements IStringSerializable
    {
        DEFAULT("default"),
        LEFT_CORNER("left_corner"),
        RIGHT_CORNER("right_corner"),
        LEFT_CORNER_INVERTED("left_corner_inverted"),
        RIGHT_CORNER_INVERTED("right_corner_inverted");

        private String id;

        private Type(String id) {
            this.id = id;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.id;
        }
    }
}

